with Matrix33_Closure;
generic
   type Value_Type is private;
package Matrix33 is

   type Object is array (1 .. 3, 1 .. 3) of Value_Type;

   function Get_Val (This     : in Object;
                     Row, Col : in Natural) return Value_Type;

   procedure Set_Val (This     : in out Object;
                      Val      : in     Value_Type;
                      Row, Col : in     Natural);

   generic
      with package Closure is new Matrix33_Closure (<>);
      with procedure Set_Val (This     : in out Object;
                              Val      : in     Closure.Value_Type;
                              Row, Col : in     Natural) is <>;
   procedure Assign_From_Closure (This: out Object);

   pragma Inline (Get_Val, Set_Val, Assign_From_Closure);

end Matrix33;
